#include "DatabaseServer.h"
#include <iostream>
#include <fstream>
using namespace std;

const char* objRefFile = "OBJ_REF_FILE.dat";

DatabaseServer::DatabaseServer()
{
}

DatabaseServer::~DatabaseServer()
{
}

void DatabaseServer::addRecord(const char* key, const char* record)
{
  mDb[key] = record;
}

char* DatabaseServer::lookupRecord(const char* key)
{
  return (CORBA::string_dup(mDb[key].c_str()));
}

int main(int argc, char** argv)
{
  // Prba inicjalizacji obiektu orb
  CORBA::ORB_var orb;
  try {
    orb = CORBA::ORB_init(argc, argv);
  } catch(CORBA::SystemException&) {
    cerr << "Nie mona zainicjowa obiektu ORB\n";
    exit(1);
  }

  // Odczyt referencji do "Portable Object Adapter" 
  // i jego rzutowanie na odpowiedni typ
  CORBA::Object_var obj = orb->resolve_initial_references("RootPOA");
  PortableServer::POA_var poa = PortableServer::POA::_narrow(obj);
  
  // Utworzenie obiektu DatabaseServer i jego rejestrowanie/aktywowanie
  // za pomoc adaptera obiektu przenonego
  DatabaseServer* myDb = new DatabaseServer();
  PortableServer::ObjectId_var dbid = poa->activate_object(myDb);

  // Zapisanie referencji obiektu w postaci cigu znakw
  // w pliku, dziki czemu klient moe go odszuka
  CORBA::Object_var dbobj = myDb->_this();
  CORBA::String_var sior(orb->object_to_string(dbobj));

  ofstream ostr(objRefFile);
  if (ostr.fail()) {
    cerr << "Nie mona otworzy pliku referencji obiektu do zapisu.\n";
    exit(1);
  } 
  ostr << (char*)sior;
  ostr.close();

  // Poinformuj licznik referencji, e zakoczylimy prac z obiektem.
  // Teraz jego referencj ma tylko POA.
  myDb->_remove_ref();

  // Zmie stan POA z wstrzymania na aktywny, dziki czemu moe
  // obsugiwa przychodzce dania.
  PortableServer::POAManager_var pman = poa->the_POAManager();
  pman->activate();

  // Oczekiwanie na przychodzce dania.
  orb->run();

  // Metoda run nie powinna si zakoczy, ale jeeli si tak zdarzy
  // musimy wykona operacje porzdkowe.
  orb->destroy();
  return (0);
}
