#include <algorithm>
#include <vector>
#include <iostream>
using namespace std;


// Szablon funkcji do wypenienia kontenera liczb int
// Kontener musi obsugiwa push_back().
template<typename Container>
void populateContainer(Container& cont)
{
  int num;

  while (true) {
    cout << "Podaj liczb do zapamitania (0 aby zatrzyma): ";
    cin >> num;
    if (num == 0) {
      break;
    }
    cont.push_back(num);
  }
}

void print(int elem)
{
  cout << elem << " ";
}

int main(int argc, char** argv)
{
  vector<int> vectorOne, vectorTwo, vectorMerged;
  cout << "Podaj wartoci dla pierwszego wektora:\n";
  populateContainer(vectorOne);
  cout << "Podaj wartoci dla drugiego wektora:\n";
  populateContainer(vectorTwo);

  sort(vectorOne.begin(), vectorOne.end());
  sort(vectorTwo.begin(), vectorTwo.end());
  // upewnij si, e wektor jest wystarczajco dugi na wartoci
  // z obu rde
  vectorMerged.resize(vectorOne.size() + vectorTwo.size());
  merge(vectorOne.begin(), vectorOne.end(), vectorTwo.begin(),
        vectorTwo.end(), vectorMerged.begin());

  cout << "Zczony wektor: ";
  for_each(vectorMerged.begin(), vectorMerged.end(), &print);
  cout << endl;

  while (true) {
    int num;
    cout << "Podaj liczb do wyszukania (0 aby zatrzyma): ";
    cin >> num;
    if (num == 0) {
      break;
    }
    if (binary_search(vectorMerged.begin(), vectorMerged.end(), num)) {
      cout << "Ta liczba znajduje si w wektorze.\n";
    } else {
      cout << "Ta liczba nie znajduje si w wektorze.\n";
    }
  }

  return (0);
}
