#include <algorithm>
#include <iostream>
#include <vector>
using namespace std;

// Szablon funkcji do wypenienia kontenera liczb int
// Kontener musi obsugiwa push_back().
template<typename Container>
void populateContainer(Container& cont)
{
  int num;

  while (true) {
    cout << "Podaj liczb do zapamitania (0 aby zatrzyma): ";
    cin >> num;
    if (num == 0) {
      break;
    }
    cont.push_back(num);
  }
}

void print(int elem)
{
  cout << elem << " ";
}

int main(int argc, char** argv)
{
  vector<int> setOne, setTwo, setThree;
  cout << "Wprowad pierwszy zbir:\n";
  populateContainer(setOne);
  cout << "Wprowad drugi zbir:\n";
  populateContainer(setTwo);

  // Algorytmy zbiorw dziaaj na posortowanych zakresach
  sort(setOne.begin(), setOne.end());
  sort(setTwo.begin(), setTwo.end());

  if (includes(setOne.begin(), setOne.end(), setTwo.begin(), setTwo.end())) {
    cout << "Drugi zbir jest podzbiorem pierwszego\n";
  }
  if (includes(setTwo.begin(), setTwo.end(), setOne.begin(), setOne.end())) {
    cout << "Pierwszy zbir jest podzbiorem drugiego\n";
  }

  setThree.resize(setOne.size() + setTwo.size());
  vector<int>::iterator newEnd;
  newEnd = set_union(setOne.begin(), setOne.end(), setTwo.begin(),
             setTwo.end(), setThree.begin());
  cout << "Suma to: ";
  for_each(setThree.begin(), newEnd, &print);
  cout << endl;

  newEnd = set_intersection(setOne.begin(), setOne.end(), setTwo.begin(),
                setTwo.end(), setThree.begin());
  cout << "Cz wsplna to: ";
  for_each(setThree.begin(), newEnd, &print);
  cout << endl;

  newEnd = set_difference(setOne.begin(), setOne.end(), setTwo.begin(),
              setTwo.end(), setThree.begin());
  cout << "Rnica midzy zbiorem pierwszym i drugim to: ";
  for_each(setThree.begin(), newEnd, &print);
  cout << endl;

  newEnd = set_symmetric_difference(setOne.begin(), setOne.end(), setTwo.begin(),
                    setTwo.end(), setThree.begin());
  cout << "Rnica symetryczna to: ";
  for_each(setThree.begin(), newEnd, &print);
  cout << endl;

  return (0);
}
