#include <list>
#include <vector>
#include <string>
#include <algorithm>
#include <iterator>
#include <fstream>
#include <iostream>
#include <sstream>
using namespace std;

//
// classLists to wektor list, po jednym na kady przedmiot. Listy zawieraj
// nazwiska studentw zapisanych na te przedmioty. Nie s one posortowane.
//
// droppedStudents to lista studentw, ktrzy nie zapacili czesnego
// wic s usuwani z przedmiotw.
//
// Funkcja zwraca list zapisanych (nie usunitych) studentw
// z wszystkich przedmiotw.
//
list<string>
getTotalEnrollment(const vector<list<string> >& classLists,
           const list<string>& droppedStudents)
{
  list<string> allStudents;

  // czenie wszystkich list przedmiotw w jedn zbiorcz list
  for (size_t i = 0; i < classLists.size(); ++i) {
    allStudents.insert(allStudents.end(), classLists[i].begin(),
               classLists[i].end());
  }

  // Sortowanie zbiorczej listy
  allStudents.sort();

  // Usunicie powielonych nazwisk studentw (zapisanych na kilka przedmiotw).
  allStudents.unique();

  //
  // Usunicie studentw, ktrzy s na licie do usunicia.
  // Przegldanie listy do usunicia i usuwanie z listy zbiorczej
  // studentw z listy do usunicia.
  //
  for (list<string>::const_iterator it = droppedStudents.begin();
       it != droppedStudents.end(); ++it) {
    allStudents.remove(*it);
  }

  // gotowe!
  return (allStudents);
}

void readStudentList(list<string> &students, ifstream &istr)
{
  string name;
  while (getline(istr, name)) {
    cout << "Odczytane nazwisko: " << name << endl;
    students.push_back(name);
  }
}

void readCourseLists(vector<list<string> > &lists)
{
  for(int i = 1; ; i++) {
    ostringstream ostr;
    ostr << "course" << i << ".txt";

    ifstream istr(ostr.str().c_str());
    if (!istr) {
      cout << "Nie mona otworzy " << ostr.str() << endl;
      break;
    }
    list<string> newList;
    readStudentList(newList, istr);
    lists.push_back(newList);
  }
}

void readDroppedStudents(list<string> &students)
{
  ifstream istr("dropped.txt");
  readStudentList(students, istr);
}

int main(int argc, char **argv)
{
  vector<list<string> > courseLists;
  list<string> droppedStudents;

  readCourseLists(courseLists);
  readDroppedStudents(droppedStudents);

  list<string> finalList = getTotalEnrollment(courseLists, droppedStudents);

  copy(finalList.begin(), finalList.end(), ostream_iterator<string>(cout, "\n"));
}
