#include "RoundRobin.h"
#include <stdexcept>
#include <iostream>
using namespace std;

//
// Deklaracja wyprzedzajca NetworkRequest
// Pominite szczegy implementacji
//
class NetworkRequest {};

//
// Prosta klasa Host, ktra suy jako odpowiednik fizycznego hosta.
// Pominite szczegy implementacji
//
class Host
{
public:
  //
  // Implementacja processRequest powinna przesya dania
  // do wza sieci reprezentowanego przez obiekt.
  // Pominita.
  //
  void processRequest(NetworkRequest& request) {} 
};

//
// Prosty wyrwnywacz obcienia, ktry rozprowadza przychodzce dania
// do hostw, korzystajc ze schematu round-robin.
//
class LoadBalancer
{
public:
  //
  // Konstruktor oczekuje wektora obiektw Host.
  //
  LoadBalancer(const vector<Host>& hosts);
  ~LoadBalancer() {}

  //
  // Przesanie przychodzcego dania do nastpnego hosta
  // z wykorzystaniem algorytmu kolejkowania round-robin.
  //
  void distributeRequest(NetworkRequest& request);

protected:
  RoundRobin<Host> rr;
};

LoadBalancer::LoadBalancer(const vector<Host>& hosts)
{
  // dodanie hostw
  for (size_t i = 0; i < hosts.size(); ++i) {
    rr.add(hosts[i]);
  }
}

void LoadBalancer::distributeRequest(NetworkRequest& request)
{
  try {
    rr.getNext().processRequest(request);
  } catch (out_of_range& e) {
    cerr << "Brak hostw.\n";
  }
}

int main(int argc, char** argv)
{
  vector<Host> hosts;
  hosts.push_back(Host());
  hosts.push_back(Host());
  hosts.push_back(Host());
  LoadBalancer lb(hosts);
  NetworkRequest r;
  lb.distributeRequest(r);
  lb.distributeRequest(r);
  lb.distributeRequest(r);
  lb.distributeRequest(r);
  lb.distributeRequest(r);
  lb.distributeRequest(r);
}
