#include <queue>
#include <stdexcept>
using std::queue;

template <typename T>
class PacketBuffer
{
 public:
  //
  // Jeeli warto maxSize jest niedodatnia, rozmiar jest nieograniczony.
  // W przeciwmym razie moliwe jest wstawienie do bufora 
  // tylko maxSize pakietw jednoczenie.
  //
  PacketBuffer(int maxSize = -1);

  //
  // Zapisuje pakiet w buforze.
  // Zgasza wyjtek overflow_error jeeli bufor jest peny.
  //
  void bufferPacket(const T& packet);

  //
  // Zwraca nastpny pakiet. Zgasza wyjtek out_of_range
  // jeeli bufor jest pusty.
  //
  T getNextPacket() throw (std::out_of_range);

 protected:
  queue<T> mPackets;
  int mMaxSize;

 private:
  // uniemoliwia przypisywanie i przekazywanie przez warto
  PacketBuffer(const PacketBuffer& src);
  PacketBuffer& operator=(const PacketBuffer& rhs);
};

template <typename T>
PacketBuffer<T>::PacketBuffer(int maxSize)
{
  mMaxSize = maxSize;
}

template <typename T>
void PacketBuffer<T>::bufferPacket(const T& packet)
{
  if (mMaxSize > 0 && mPackets.size() == static_cast<size_t>(mMaxSize)) {
    // Brak miejsca, odrzucamy pakiet.
    return;
  }

  mPackets.push(packet);
}

template <typename T>
T PacketBuffer<T>::getNextPacket() throw (std::out_of_range)
{
  if (mPackets.empty()) {
    throw (std::out_of_range("Bufor jest pusty"));
  }
  // Pobranie pierwszego elementu.
  T temp = mPackets.front();
  // Zdjcie pierwszego elementu.
  mPackets.pop();
  // Zwrcenie pierwszego elementu.
  return (temp);
}
