#include "ErrorCorrelator.h"
using namespace std;

bool operator<(const Error& lhs, const Error& rhs)
{
  return (lhs.mPriority < rhs.mPriority);
}

ostream& operator<<(ostream& str, const Error& err)
{
  str << err.mError << " (priorytet " << err.mPriority << ")";
  return (str);
}

void ErrorCorrelator::addError(const Error& error)
{
  mErrors.push(error);
}

Error ErrorCorrelator::getError() throw (out_of_range)
{
  //
  // Jeeli nie ma wicej bdw, zgo wyjtek.
  //
  if (mErrors.empty()) {
    throw (out_of_range("Brak elementw!"));
  }
  
  // Zapamitanie pierwszego elementu.
  Error top = mErrors.top();
  // Usunicie pierwszego elementu.
  mErrors.pop();
  // Zwrcenie zapamitanego elementu.
  return (top);
}
