#include <bitset>
#include <map>
#include <string>
#include <stdexcept>
using std::map;
using std::bitset;
using std::string;
using std::out_of_range;

const int kNumChannels = 10;

class CableCompany
{
 public:
  CableCompany() {}

  // Dodaje do bazy danych pakiet z okrelonymi kanaami.
  void addPackage(const string& packageName,
          const bitset<kNumChannels>& channels);

  // Usuwa okrelony pakiet z bazy danych.
  void removePackage(const string& packageName);

  // Dodaje do bazy danych klienta z pocztkowymi kanaami z pakietu.
  // Zgasza wyjtek out_of_range jeeli nazwa pakietu jest nieprawidowa.
  void newCustomer(const string& name, const string& package)
    throw (out_of_range);

  // Dodaje do bazy danych klienta z pocztkowymi kanaami 
  // okrelonymi w parametrze channels.
  void newCustomer(const string& name, const bitset<kNumChannels>& channels);

  // Dodaje kana do profilu klienta.
  void addChannel(const string& name, int channel);

  // Usuwa kana z profilu klienta.
  void removeChannel(const string& name, int channel);

  // Dodaje pakiet do profilu klienta.
  void addPackageToCustomer(const string& name, const string& package);

  // Usuwa klienta z bazy danych.
  void deleteCustomer(const string& name);

  // Odczytuje kanay subskrybowane przez klienta.
  // Zgasza wyjtek out_of_range jeeli nie znaleziono klienta.
  bitset<kNumChannels>& getCustomerChannels(const string& name)
    throw (out_of_range);

 protected:
  typedef map<string, bitset<kNumChannels> > MapType;
  MapType mPackages, mCustomers;
};
