#include <map>
#include <string>
#include <stdexcept>
using std::map;
using std::string;
using std::out_of_range;

class BankAccount
{
 public:
  BankAccount(int acctNum, const string& name) :
    mAcctNum(acctNum), mClientName(name) {}
  void setAcctNum(int acctNum) { mAcctNum = acctNum; }
  int getAcctNum() const {return (mAcctNum); }
  void setClientName(const string& name) { mClientName = name; }
  string getClientName() const { return mClientName; }

  // Pozostae metody publiczne pominite

 protected:
  int mAcctNum;
  string mClientName;
  // Pozostae other pola danych pominite
};

class BankDB
{
 public:
  BankDB() {}

  // Dodaje konto do bazy danych banku. Jeeli istnieje konto 
  // o podanym numerze, nowe konto nie jest zakadane.
  // Zwraca true, jeeli konto zostanie dodane, 
  // false jeeli nie zostanie dodane.
  bool addAccount(const BankAccount& acct);

  // Usuwa z bazy danych konto acctNum.
  void deleteAccount(int acctNum);

  // Zwraca referencj do konta reprezentowanego przez
  // jego numer lub nazwisko klienta.
  // Zgasza wyjtek out_of_range jeeli konto nie zostanie znalezione.
  BankAccount& findAccount(int acctNum) throw(out_of_range);
  BankAccount& findAccount(const string& name) throw(out_of_range);

  // Dodaje wszystkie konta z db do biecej bazy danych.
  // Usuwa wszystkie konta z db.
  void mergeDatabase(BankDB& db);

 protected:
  map<int, BankAccount> mAccounts;
};

