#include "BankDB.h"
#include <utility>
using namespace std;

bool BankDB::addAccount(const BankAccount& acct)
{
  // Deklaracja zmiennej zapamitujcej wynik insert().
  pair<map<int, BankAccount>::iterator, bool> res;
  // Wykonanie wstawienia korzystajc z numeru konta jako klucza.
  res = mAccounts.insert(make_pair(acct.getAcctNum(), acct));

  // Zwrcenie pola bool z obiektu pair
  return (res.second);
}

void BankDB::deleteAccount(int acctNum)
{
  mAccounts.erase(acctNum);
}

BankAccount& BankDB::findAccount(int acctNum) throw(out_of_range)
{
  // Wyszukanie elementu na podstawie klucza mona zrealizowa za pomoc find()
  map<int, BankAccount>::iterator it = mAccounts.find(acctNum);
  if (it == mAccounts.end()) {
    throw (out_of_range("Brak konta o podanym numerze."));
  }
  // Pamitaj, e iteratory map odwouj si do par klucz-warto.
  return (it->second);
}

BankAccount& BankDB::findAccount(const string& name) throw(out_of_range)
{
  //
  // Wyszukanie elementu na podstawie atrybutu niekluczowego wymaga liniowego
  // przeszukania elementw.
  //
  for (map<int, BankAccount>::iterator it = mAccounts.begin();
       it != mAccounts.end(); ++it) {
    if (it->second.getClientName() == name) {
      // found it!
      return (it->second);
    }
  }
  throw (out_of_range("Brak konta z tym nazwiskiem."));
}

void BankDB::mergeDatabase(BankDB& db)
{
  // Wstawienie kopii wszystkich kont ze starej bazy danych
  // do nowej.
  mAccounts.insert(db.mAccounts.begin(), db.mAccounts.end());

  // Skasowanie wszystkich kont ze starej bd.
  db.mAccounts.clear();
}
