#include <set>
#include <string>
#include <list>
using std::set;
using std::string;
using std::list;

class AccessList
{
 public:
  AccessList() {}

  //
  // Dodaje uytkownika do listy uprawnionych.
  //
  void addUser(const string& user);

  //
  // Usuwa uytkownika z listy uprawnionych.
  //
  void removeUser(const string& user);

  //
  // Zwraca true, jeeli uzytkownik znajduje si na licie uprawnionych.
  //
  bool isAllowed(const string& user) const;

  //
  // Zwraca list wszystkich uprawnionych uytkownikw.
  //
  list<string> getAllUsers() const;

 protected:
  set<string> mAllowed;
};
