// STDebug.cpp
#include <exception>
#include <fstream>
#include <iostream>
using namespace std;

ofstream debugOstr;
bool debug = false;

const char* debugFileName = "debugfile.out";

class ComplicatedClass
{
public:
  ComplicatedClass() {}
  ~ComplicatedClass() {}
};

class UserCommand
{
public:
  UserCommand() {}
};

bool isDebugSet(int argc, char** argv);
ostream& operator<<(ostream& ostr, const ComplicatedClass& src);
ostream& operator<<(ostream& ostr, const UserCommand& src);
UserCommand getNextCommand(ComplicatedClass* obj);
void processUserCommand(UserCommand& cmd);
void trickyFunction(ComplicatedClass* obj) throw(exception);

int main(int argc, char** argv)
{

  debug = isDebugSet(argc, argv);
  if (debug) {
    // otwarcie strumienia wyjciowego
    debugOstr.open(debugFileName);
    if (debugOstr.fail()) {
    cout << "Nie mona otworzy pliku diagnostycznego!\n";
      return (1);
    }

  // Zapisywanie argumentw wiersza polece
    for (int i = 0; i < argc; i++) {
      debugOstr << argv[i] << " ";
      debugOstr << endl;
    }
  }

  ComplicatedClass obj;
  trickyFunction(&obj);

  // Pozostaa cz funkcji nie jest zamieszczona
  return (0);
}

bool isDebugSet(int argc, char** argv)
{
  for (int i = 0; i < argc; i++) {
    if (strcmp(argv[i], "-d") == 0) {
      return (true);
    }
  }
  return (false);
}

ostream& operator<<(ostream& ostr, const ComplicatedClass& src)
{
  ostr << "ComplicatedClass";
  return (ostr);
}

ostream& operator<<(ostream& ostr, const UserCommand& src)
{
  ostr << "UserCommand";
  return (ostr);
}

UserCommand getNextCommand(ComplicatedClass* obj)
{
  UserCommand cmd;
  return (cmd);
}

void processUserCommand(UserCommand& cmd)
{
  // dla uproszczenia szczegy zostay opuszczone 
}

void trickyFunction(ComplicatedClass* obj) throw(exception)
{
  if (debug) {
  // Wczony tryb diagnostyczny, wywietlanie wartoci z ktrymi zosta uruchomiony program
  debugOstr << "trickyFunction(): podane argumenty: " << *obj << endl;
  }

  while (true) {
    UserCommand cmd = getNextCommand(obj);
    if (debug) {
      debugOstr << "trickyFunction(): pobrane polecenie " << cmd << endl;
    }
    try {
      processUserCommand(cmd);
    } catch (exception& e) {
      if (debug) {
        debugOstr << "trickyFunction(): "
                << " przechwycony wyjtek z procesUserCommand(): "
                << e.what() << endl;
      }
      throw;
    }
  }
}
