#include <fstream>
#include <iostream>
#include <vector>
#include <string>
#include <exception>

using namespace std;

void readIntegerFile(const string& fileName, vector<int>& dest)
{
  ifstream istr;
  int temp;

  istr.open(fileName.c_str());
  if (istr.fail()) {
    // Nie udao si otworzy pliku - zgo wyjtek.
    throw exception();
  }

  // Odczytuje kolejne wartoci cakowite i dodaje je do wektora.
  while (istr >> temp) {
    dest.push_back(temp);
  }

  if (istr.eof()) {
    // Osignlimy koniec pliku.
    istr.close();
  } else {
    // Inny bd. Zgo wyjtek.
    istr.close();
    throw exception();
  }
}

int main(int argc, char** argv)
{
  vector<int> myInts;
  const string fileName = "IntegerFile.txt";

  try {
    readIntegerFile(fileName, myInts);
  } catch (const exception& e) {
    cout << "Nie udao si otworzy lub odczyta pliku " << fileName << endl;
    exit (1);
  }

  for (size_t i = 0; i < myInts.size(); i++) {
    cout << myInts[i] << " ";
  }
  cout << endl;

  return (0);
}


