#include <fstream>
#include <iostream>
#include <vector>
#include <string>
#include <exception>

using namespace std;

void readIntegerFile(const string& fileName, vector<int>& dest)
{
  ifstream istr;
  int temp;

  istr.open(fileName.c_str());
  if (istr.fail()) {
    // Nie udao si otworzy pliku - zgo wyjtek.
    throw "Nie udao si otworzy pliku";
  }

  // Odczytuje kolejne wartoci cakowite i dodaje je do wektora.
  while (istr >> temp) {
    dest.push_back(temp);
  }
}

int main(int argc, char** argv)
{
  vector<int> myInts;
  const string fileName = "IntegerFile.txt";

  try {
    readIntegerFile(fileName, myInts);
  } catch (const char* e) {
    cerr << e << endl;
    exit (1);
  }

  for (size_t i = 0; i < myInts.size(); i++) {
    cout << myInts[i] << " ";
  }
  cout << endl;

  return (0);
}
