#include <iostream>
#include <sstream>
#include <string>

using namespace std;

class Muffin 
{
    public:
        string    getDescription() const;
        void      setDescription(const string& inDescription);
        int       getSize() const;
        void      setSize(int inSize);
        bool      getHasChocolateChips() const;
        void      setHasChocolateChips(bool inChips);

        void output();
    protected:
        string    mDescription;
        int       mSize;
        bool      mHasChocolateChips;
};

string Muffin::getDescription() const { return mDescription; }
void Muffin::setDescription(const string& inDescription) { mDescription = inDescription; }
int Muffin::getSize() const { return mSize; }
void Muffin::setSize(int inSize) { mSize = inSize; }
bool Muffin::getHasChocolateChips() const { return mHasChocolateChips; }
void Muffin::setHasChocolateChips(bool inChips) { mHasChocolateChips = inChips; }

void Muffin::output()
{
  printf("%s, Wielko: %d, %s\n", getDescription().c_str(), getSize(),    
	 (getHasChocolateChips() ? "zawiera patki" : "bez patkw"));
}

Muffin createMuffin(istringstream& inStream);

int main(int argc, char** argv)
{
  cout << "Najpierw utwrzmy w kodzie obiekt Muffin i pokamy go." << endl;

  Muffin m;
  m.setDescription("Giant_Blueberry_Muffin");
  m.setSize(42);
  m.setHasChocolateChips(false);

  m.output();

  cout << "Teraz tworzymy obiekt Muffin na podstawie strumienia acuchowego." << endl;

  istringstream instream("My_Muffin 2 true");
  Muffin m2 = createMuffin(instream);

  m2.output();
}

Muffin createMuffin(istringstream& inStream)
{
  Muffin muffin;
  // Zakadamy, e dane s prawidowo sformatowane:
  // opis wielko patki

  string description;
  int size;
  bool hasChips;

  // Wczytujemy wszystkie trzy wartoci. Obecno patkw jest
  // opisana acuchem "true" lub "false".
  inStream >> description >> size >> boolalpha >> hasChips;
  muffin.setSize(size);
  muffin.setDescription(description);
  muffin.setHasChocolateChips(hasChips);

  return muffin;
}
