template <typename T>
class Grid
{
    public:
        Grid(int inWidth = kDefaultWidth, int inHeight = kDefaultHeight);
        Grid(const Grid<T>& src);
        template <typename E>
          Grid(const Grid<E>& src);
        ~Grid();

        Grid<T>& operator=(const Grid<T>& rhs);
        template <typename E>
          Grid<T>& operator=(const Grid<E>& rhs);

        void setElementAt(int x, int y, const T& inElem);
        T& getElementAt(int x, int y);
        const T& getElementAt(int x, int y) const;

        int getHeight() const { return mHeight; }
        int getWidth() const { return mWidth; }

        static const int kDefaultWidth = 10;
        static const int kDefaultHeight = 10;

    protected:
        void copyFrom(const Grid<T>& src);
        template <typename E>
          void copyFrom(const Grid<E>& src);

        T** mCells;
        int mWidth, mHeight;
};

template <typename T>
Grid<T>::Grid(int inWidth, int inHeight) : mWidth(inWidth), mHeight(inHeight)
{
    mCells = new T* [mWidth];
    for (int i = 0; i < mWidth; i++) {
        mCells[i] = new T[mHeight];
    }
}

template <typename T>
const int Grid<T>::kDefaultWidth;

template <typename T>
const int Grid<T>::kDefaultHeight;

template <typename T>
Grid<T>::Grid(const Grid<T>& src)
{
    copyFrom(src);
}

template <typename T>
Grid<T>::~Grid()
{
    // zwalniamy zbdn ju pami
    for (int i = 0; i < mWidth; i++) {
        delete [] mCells[i];
    }
    delete [] mCells;
}

template <typename T>
void Grid<T>::copyFrom(const Grid<T>& src)
{
    int i, j;
    mWidth = src.mWidth;
    mHeight = src.mHeight;

    mCells = new T* [mWidth];
    for (i = 0; i < mWidth; i++) {
        mCells[i] = new T[mHeight];
    }

    for (i = 0; i < mWidth; i++) {
        for (j = 0; j < mHeight; j++) {
            mCells[i][j] = src.mCells[i][j];
        }
    }
}

template <typename T>
Grid<T>& Grid<T>::operator=(const Grid<T>& rhs)
{
    // sprwadzamy, czy nie jest to przypisanie do tego samego obiektu
    if (this == &rhs) {
        return (*this);
    }
    // zwalniamy zbdn ju pami
    for (int i = 0; i < mWidth; i++) {
        delete [] mCells[i];
    }
    delete [] mCells;

    // kopiowanie nowej pamici
    copyFrom(rhs);

    return (*this);
}

template <typename T>
void Grid<T>::setElementAt(int x, int y, const T& inElem)
{
    mCells[x][y] = inElem;
}

template <typename T>
T& Grid<T>::getElementAt(int x, int y)
{
    return (mCells[x][y]);
}

template <typename T>
const T& Grid<T>::getElementAt(int x, int y) const
{
    return (mCells[x][y]);
}

template <typename T>
template <typename E>
Grid<T>::Grid(const Grid<E>& src)
{
    copyFrom(src);
}

template <typename T>
template <typename E>
void Grid<T>::copyFrom(const Grid<E>& src)
{
    int i, j;
    mWidth = src.getWidth();
    mHeight = src.getHeight();

    mCells = new T* [mWidth];
    for (i = 0; i < mWidth; i++) {
        mCells[i] = new T[mHeight];
    }
    for (i = 0; i < mWidth; i++) {
        for (j = 0; j < mHeight; j++) {
            mCells[i][j] = src.getElementAt(i, j);
          }
    }
}

template <typename T>
template <typename E>
Grid<T>& Grid<T>::operator=(const Grid<E>& rhs)
{
    // zwalnianie zbdnej ju pamii
    for (int i = 0; i < mWidth; i++) {
        delete [] mCells[i];
    }
    delete [] mCells;

    // kopiowanie nowej pamici
    copyFrom(rhs);

    return (*this);
}
