// Grid.h

#include <vector>
using std::vector;
using std::allocator;

template <typename T, template <typename E, typename Allocator = allocator<E> >
    class Container = vector >
class Grid
{
 public:
  Grid(int inWidth = kDefaultWidth, int inHeight = kDefaultHeight);
  Grid(const Grid<T, Container>& src);
  ~Grid();
  Grid<T, Container>& operator=(const Grid<T, Container>& rhs);

  void setElementAt(int x, int y, const T& inElem);
  T& getElementAt(int x, int y);
  const T& getElementAt(int x, int y) const;

  int getHeight() const { return mHeight; }
  int getWidth() const { return mWidth; }
  static const int kDefaultWidth = 10;
  static const int kDefaultHeight = 10;

 protected:
  void copyFrom(const Grid<T, Container>& src);
  Container<T>* mCells;
  int mWidth, mHeight;
};

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
Grid<T, Container>::Grid(int inWidth, int inHeight) :
  mWidth(inWidth), mHeight(inHeight)
{
  // Dynamiczna alokacja tablicy na mWidth kontenerw.
  mCells = new Container<T>[mWidth];
  for (int i = 0; i < mWidth; i++) {
    // Zmiana wielkoci kadego kontenera, aby mieci mHeight elementw.
    mCells[i].resize(mHeight);
  }
}

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
const int Grid<T, Container>::kDefaultWidth;

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
const int Grid<T, Container>::kDefaultHeight;

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
Grid<T, Container>::Grid(const Grid<T, Container>& src)
{
  copyFrom(src);
}

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
  Grid<T, Container>::~Grid()
{
  delete [] mCells;
}

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
void Grid<T, Container>::copyFrom(const Grid<T, Container>& src)
{
  int i, j;
  mWidth = src.mWidth;
  mHeight = src.mHeight;

  mCells = new Container<T>[mWidth];
  for (i = 0; i < mWidth; i++) {
    // Zmiana wielkoci kadego elementu jak w konstruktorze.
    mCells[i].resize(mHeight);
  }
  for (i = 0; i < mWidth; i++) {
    for (j = 0; j < mHeight; j++) {
      mCells[i][j] = src.mCells[i][j];
    }
  }
}

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
Grid<T, Container>& Grid<T, Container>::operator=(const Grid<T, Container>& rhs)
{
  // ochrona przed przypisaniem do samego siebie
  if (this == &rhs) {
    return (*this);
  }
  // zwolnienie starej pamici
  delete [] mCells;

  // kopiowanie nowej pamici
  copyFrom(rhs);

  return (*this);
}

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
void Grid<T, Container>::setElementAt(int x, int y, const T& inElem)
{
  mCells[x][y] = inElem;
}

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
T& Grid<T, Container>::getElementAt(int x, int y)
{
  return (mCells[x][y]);
}

template <typename T, template <typename E, typename Allocator = allocator<E> > class Container>
const T& Grid<T, Container>::getElementAt(int x, int y) const
{
  return (mCells[x][y]);
}
