// Spreadsheet.h
#include "SpreadsheetCell.h"

class SpreadsheetApplication; // deklaracja wyprzedzajca

class Spreadsheet
{
 public:
  Spreadsheet(int inWidth, int inHeight,
	      const SpreadsheetApplication& theApp);
  Spreadsheet(const Spreadsheet& src);
  ~Spreadsheet();
  Spreadsheet& operator=(const Spreadsheet& rhs);

  void setCellAt(int x, int y, const SpreadsheetCell& cell);
  SpreadsheetCell getCellAt(int x, int y);

  int getId();

  // Nie dziaa w Microsoft Visual Studio 6
  static const int kMaxHeight = 100;
  static const int kMaxWidth = 100;

 protected:
  bool inRange(int val, int upper);
  void copyFrom(const Spreadsheet& src);

  int mWidth, mHeight;
  int mId;
  SpreadsheetCell** mCells;

  const SpreadsheetApplication& mTheApp;

  static int sCounter;
}; 
