type
 pbtree = ^btree;  //wskaznik do klasy btree
 btree = object
  private
   rodzic : pbtree;
   lewy, prawy : pbtree;
   obiekt : integer;

  public
   constructor Init();
   function CzyJestPusty() : Boolean;
   function CzyNalezy(d : integer) : pbtree;
   procedure Dodaj(d : integer);
   procedure Usun(d : integer);
   procedure Usun(t : pbtree);
   function Min() : pbtree;
   function Max() : pbtree;
   procedure DrukujPreorder(d : pbtree);
   destructor Done;
  private
   constructor Init(s : pbtree; d : integer);
   destructor Usun;
 end;

constructor btree.Init();
 begin
  obiekt:=-1;
  lewy:=NIL;
  prawy:=NIL;
  rodzic:=NIL;
 end;

constructor btree.Init(s : pbtree; d : integer);
 begin
  Init();
  obiekt:=d;
  rodzic:=s;
 end;

destructor btree.Done();
 begin
  if (lewy<>NIL) Then Dispose(lewy,Done);
  if (prawy<>NIL) Then Dispose(prawy,Done);
  if (rodzic<>NIL) Then if (rodzic^.lewy=@self) Then rodzic^.lewy:=NIL
   else rodzic^.prawy:=NIL;
 end;

destructor btree.Usun();
 begin
 end;

function btree.CzyJestPusty() : Boolean;
 begin
  if obiekt=-1 Then CzyJestPusty:=True else CzyJestPusty:=False;
 end;

function btree.CzyNalezy(d : integer) : pbtree;
 begin
  if (d=obiekt) Then CzyNalezy:=@self
   else if (d<obiekt) Then if (lewy<>NIL) Then CzyNalezy:=lewy^.CzyNalezy(d) else CzyNalezy:=NIL
    else if (prawy<>NIL) Then CzyNalezy:=prawy^.CzyNalezy(d) else CzyNalezy:=NIL;
 end;

procedure btree.Dodaj(d : integer);
 begin
  if CzyJestPusty() Then obiekt:=d
   else
    begin
     if (d<obiekt) Then
      begin
       if (lewy=NIL) Then lewy:=new(pbtree,Init(@self,d))
        else lewy^.Dodaj(d);
      end
       else
      begin
       if(prawy=NIL) Then prawy:=new(pbtree,Init(@self,d))
        else prawy^.Dodaj(d);
      end;
    end;
 end;

procedure btree.Usun(d : integer);
 begin
  Usun(CzyNalezy(d));
 end;

procedure btree.Usun(t : pbtree);
 var
  iledzieci : integer =2;
  temp : pbtree;
 begin
  if (t<>NIL) Then
   begin
    if (t^.lewy=NIL) Then DEC(iledzieci);
    if (t^.prawy=NIL) Then DEC(iledzieci);
    case (iledzieci) of
         //Brak dzieci
     0 : if (t^.rodzic=NIL) Then t^.Obiekt:=-1 else dispose(t,Usun);
         //jedno dziecko
     1 : if (t^.lewy<>NIL) Then
          begin
           t^.lewy^.rodzic:=t^.rodzic;
           if (t^.rodzic<>NIL) Then
            begin
             if (t^.rodzic^.lewy=t) Then t^.rodzic^.lewy:=t^.lewy
              else t^.rodzic^.prawy:=t^.lewy;
             dispose(t,Usun);
            end
             else
              begin
               t^.obiekt:=t^.lewy^.obiekt;
               dispose(t^.lewy,Done);
              end;
          end else
          begin
           t^.prawy^.rodzic:=t^.rodzic;
           if (t^.rodzic<>NIL) Then
            begin
             if (t^.rodzic^.prawy=t) Then t^.rodzic^.prawy:=t^.prawy
              else t^.rodzic^.lewy:=t^.prawy;
             dispose(t,Usun);
             end
             else
              begin
               t^.obiekt:=t^.prawy^.obiekt;
               dispose(t^.prawy,Done);
              end;
          end;
          //dwoje dzieci
     2 : begin
          temp:=t^.prawy^.Min();
          t^.obiekt:=temp^.obiekt;
          temp^.rodzic^.lewy:=temp^.prawy;
          dispose(temp,Usun);
         end;
    end;
   end;
 end;

function btree.Min() : pbtree;
 begin
  if (lewy=NIL) Then Min:=@self else Min:=lewy^.Min();
 end;

function btree.Max() : pbtree;
 begin
  if (prawy=NIL) Then Max:=@self else Max:=prawy^.Max();
 end;

procedure btree.DrukujPreorder(d : pbtree);
 begin
  if(d<>NIL) then
   begin
    write(d^.obiekt,',');
    if(d^.lewy<>NIL) then DrukujPreorder(d^.lewy);
    if(d^.prawy<>NIL) then DrukujPreorder(d^.prawy);
   end;
 end;


var
 drzewo : pbtree;

begin
 drzewo:=new(pbtree,Init());
 drzewo^.Dodaj(16);
 drzewo^.Dodaj(6);
 drzewo^.Dodaj(38);
 drzewo^.Dodaj(20);
 drzewo^.Dodaj(21);
 drzewo^.Dodaj(71);
 drzewo^.Dodaj(39);
 drzewo^.Dodaj(72);

// if(drzewo^.CzyNalezy(10)=NIL) Then Writeln('nie nalezy') else writeln('nalezy');
// drzewo^.Usun(10);
// if(drzewo^.CzyNalezy(10)=NIL) Then Writeln('nie nalezy') else writeln('nalezy');

 writeln('Struktura drzewa');
 drzewo^.DrukujPreorder(drzewo);
 writeln();
 drzewo^.Usun(38);
 drzewo^.DrukujPreorder(drzewo);

 dispose(drzewo,Done);

end.

