#!/usr/bin/env python3
from elasticsearch import Elasticsearch
from datetime import datetime
import argparse
import json
import logging

# Analiza opcji wywołania
parser = argparse.ArgumentParser(description='Elsticsearch Query Options')
parser.add_argument("-i", "--index", help="index to query")
parser.add_argument("-q", "--query", help="query file")

args = parser.parse_args()


# Rejestracja
today = str(datetime.today())
logging.basicConfig(filename='elastic_query.log', level=logging.INFO)


# Wczytanie indeksu Elasticsearch i przeszukanie informacji z treści 
query_file = args.query
with open(query_file) as f:
    query_body = json.loads(f.read())


# Instanacja Elasticsearch 
es = Elasticsearch(["https://elastic:-Rel0twWMUk8L-ZtZr=I@192.168.2.126:9200/"],
                        ca_certs=False, verify_certs=False)

# Przeszukanie indeksu i wstawienie do słownika
index = args.index
res = es.search(index=index, body=query_body)
print(res['aggregations']['network_bytes_sum']['value'])



