// kontroler_muzyczny
// Tylko Arduino Leonardo
// Akcelerometr z serwisu Adafruit

int gndPin = A2;
int xPin = 5;
int yPin = 4;
int zPin = 3;
int plusPin = A0;

int levelX = 0;
int oldTilt = 4;

void setup() 
{
  pinMode(gndPin, OUTPUT);
  digitalWrite(gndPin, LOW);
  
  pinMode(plusPin, OUTPUT);
  digitalWrite(plusPin, HIGH);
  calibrate();
  Keyboard.begin();
}

void loop() 
{
  int x = analogRead(xPin);
  // levelX-70 levelX levelX + 70
  int tilt = (x - levelX) / 14 + 4;
  if (tilt < 0) tilt = 0;
  if (tilt > 8) tilt = 8;
  // 0 to lewo, 4 to ułożenie poziome, 8 to prawo
  if (tilt != oldTilt)
  {
      Keyboard.print(tilt);
      oldTilt = tilt;
  }
}

void calibrate()
{
  delay(200); // dajemy akcelerometrowi czas na włączenie się
  levelX = analogRead(xPin);
}
