
library(tidyverse)
library(readxl)
library(writexl)

census <- read_csv('dane/cenzus/cenzus.csv')
glimpse(census)


divisions <- read_csv('dane/cenzus/cenzus-oddziały.csv')
glimpse(divisions)

# 0. Połączenie danych
census <- left_join(census, divisions)
head(census)

# 1. Sortowanie rosnąco według regionu i oddziału oraz malejąco według liczby ludności
# Zapis danych w arkuszu Excela
census %>% 
  arrange(region, oddział, desc(liczba.ludności)) %>% 
  write_xlsx("dane/cenzus/rozwiązanie-ćwiczeń/cenzus-posortowane-r.xlsx")


# 2.Usunięcie pola kod.pocztowy ze zbioru połączonych danych
census <- select(census, -kod.pocztowy)
head(census)

# 3. Utworzenie kolumny gęstość.zaludnienia, której wartości
# są równie liczbie ludności podzielonej przez powierzchnię
census <- mutate(census, gęstość.zaludnienia = liczba.ludności/powierzchnia)
head(census)

# 4. Wizualizacja związku powierzchni z populacją dla obserwacji z 2015 roku
census_2015 <- filter(census, rok == 2015)

ggplot(data = census_2015, aes(x = powierzchnia, y = liczba.ludności))+
  geom_point()


# UWAGA: W potoku możesz wywołać `ggplot()`...
census %>% 
  filter(rok == 2015) %>% 
  ggplot(aes(x = powierzchnia, y = liczba.ludności)) + geom_point()


# Bonus: Sprawdzenie dużych powierzchni...
census_2015 %>% arrange(desc(powierzchnia))


# 5. Znajdowanie łącznej liczby mieszkańców w regionach USA w 2015 roku 
census_2015 %>% 
  group_by(region) %>% 
  summarise(ttl_liczba.ludności = sum(liczba.ludności))


# # 6. Tabela zawierającą nazwy stanów i liczbę ludności, w której liczba ludności
# z każdego roku od 2010 do 2015 przechowywana jest w osobnej kolumnie
# Na początek dodaję kolumnę z indeksem
pivot_wider(data = select(census, c('stan','rok','liczba.ludności')), 
            names_from = 'rok', values_from = 'liczba.ludności')

