<?php

class AdminController extends Controller
{
    public function actionWpisy()
    {
        $this->pageTitle = 'Wpisy';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        $WpisDodany = false;

        $ModelDodaj = new BlogWpisy;

        if(isset($_POST['BlogWpisy']))
        {
            $ModelDodaj->attributes=$_POST['BlogWpisy'];

            $ModelDodaj->wpis_data = date('Y-m-d');

            if($ModelDodaj->validate())
            {
				$ModelDodaj->save();

                $WpisDodany = true;
                $ModelDodaj->wpis_tytul = '';
                $ModelDodaj->wpis_tresc = '';
                $ModelDodaj->wpis_kategoria = '';
                $ModelDodaj->wpis_data = '';
            }
        }

        $Dane = new CActiveDataProvider('BlogWpisy', array(
            'criteria'=>array(
                'order'=>'wpis_id DESC',
                            )
                    )
                );

         $this->render('wpisy',array(
            'Dane' => $Dane,
            'WpisDodany' => $WpisDodany,
            'ModelDodaj' => $ModelDodaj,
            'ModelKategorie' => $ModelKategorie,
        ));
    }

    public function actionWpisUsun($id)
    {
        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

        BlogWpisy::model()->deleteByPk($id);

        $this->redirect(array('admin/wpisy'));
    }

    public function actionWpisAktualizuj($id)
    {
        $this->pageTitle = 'Edycja wpisu';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

        $WpisZaktualizowany = false;

        $model = BlogWpisy::model()->findByPk($id);

        if(isset($_POST['BlogWpisy']))
        {
            $model->attributes = $_POST['BlogWpisy'];

            if($model->validate())
            {
				$model->save();

                $WpisZaktualizowany = true;
            }
        }

        $this->render('wpisaktualizuj',array(
            'model' => $model,
            'WpisZaktualizowany' => $WpisZaktualizowany
        ));
    }

    public function actionKategorie()
    {
        $this->pageTitle = 'Kategorie';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        $KategoriaDodana = false;

        $ModelDodaj = new BlogKategorie;

        if(isset($_POST['BlogKategorie']))
        {
            $ModelDodaj->attributes=$_POST['BlogKategorie'];

            if($ModelDodaj->validate())
            {
				$ModelDodaj->save();

                $KategoriaDodana = true;
                $ModelDodaj->kategoria_nazwa = '';
            }
        }

        $Dane = new CActiveDataProvider('BlogKategorie');

         $this->render('kategorie',array(
            'Dane' => $Dane,
            'KategoriaDodana' => $KategoriaDodana,
            'ModelDodaj' => $ModelDodaj
        ));
    }

    public function actionKategorieUsun($id)
    {
        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

        BlogKategorie::model()->deleteAll('kategoria_id=:IdKategorii', array(':IdKategorii'=>$id));

        $this->redirect(array('admin/kategorie'));
    }

    public function actionKategorieAktualizuj($id)
    {
        $this->pageTitle = 'Edycja kategorii';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

        $KategoriaZaktualizowana = false;

        $model = BlogKategorie::model()->findByPk($id);

        if(isset($_POST['BlogKategorie']))
        {
            $model->attributes = $_POST['BlogKategorie'];

            if($model->validate())
            {
				$model->save();

                $KategoriaZaktualizowana = true;
            }
        }

        $this->render('kategorieaktualizuj',array(
            'model' => $model,
            'KategoriaZaktualizowana' => $KategoriaZaktualizowana
        ));
    }

    public function actionKomentarze()
    {
        $this->pageTitle = 'Komentarze';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        $this->pageTitle = 'Komentarze';

        $Dane = new CActiveDataProvider('BlogKomentarze');

         $this->render('komentarze',array(
            'Dane' => $Dane,
        ));
    }

    public function actionKomentarzUsun($id)
    {
        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

        BlogKomentarze::model()->deleteAll('komentarz_id=:IdKomentarza', array(':IdKomentarza'=>$id));

        $this->redirect(array('admin/komentarze'));
    }

    public function actionHaslo()
    {
        $this->pageTitle = 'Zmiana hasła';

		if(!is_numeric(Yii::app()->session['root']))
		{
			exit();
		}

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        $BladPrzyZmianie = false;

        $model = new BlogZmianaHasla;

        $ModelUzytkownicy = new BlogUzytkownicy;

        if(isset($_POST['BlogZmianaHasla']))
        {
            $model->attributes=$_POST['BlogZmianaHasla'];

            if($model->validate())
            {
                $Rezultat = $ModelUzytkownicy->findByPk(Yii::app()->session['root']);

				$StareHaslo = $Rezultat->uzytkownik_haslo;

                if($StareHaslo == md5($model->uzytkownik_haslo))
                {
                    if($model->uzytkownik_nowehaslo == $model->uzytkownik_nowehaslo2)
                    {
                        $AktualizujUzytkownika = BlogUzytkownicy::model()->findByPk(Yii::app()->session['root']);
                        $AktualizujUzytkownika->uzytkownik_haslo = md5($model->uzytkownik_nowehaslo);
                        $AktualizujUzytkownika->save();

                        $BladPrzyZmianie = 'brak_bledow';
                    }
                    else
                    {
                        $BladPrzyZmianie = 'hasla_nie_pasuja';
                    }
                }
                else
                {
                    $BladPrzyZmianie = 'zle_haslo';
                }
            }
        }

        $this->render('haslo',
                    array(
                        'model'=>$model,
                        'BladPrzyZmianie' => $BladPrzyZmianie
                        )
                    );
    }
}