<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/PLANETY">
        <HTML>
            <HEAD>
                <TITLE>
                    Elegancka tabela planet
                </TITLE>
            </HEAD>
            <BODY>
                <H1>
                    Elegancka tabela planet
                </H1>
                <TABLE BORDER="2">
                    <TR>
                        <TD>Nazwa</TD>
                        <TD>Masa</TD>
                        <TD>Promie</TD>
                        <TD>Dzie</TD>
                    </TR>
                    <xsl:apply-templates/>
                </TABLE>
            </BODY>
        </HTML>
    </xsl:template>
    
    <xsl:template match="PLANETA">
       <xsl:if test="NAZWA='Ziemia'">
       <TR>
          <TD><xsl:apply-templates select="NAZWA" mode="fancy"/></TD>
          <TD><xsl:apply-templates select="MASA" mode="fancy"/></TD>
          <TD><xsl:apply-templates select="PROMIE" mode="fancy"/></TD>
          <TD><xsl:apply-templates select="DZIE" mode="fancy"/></TD>
       </TR>
       </xsl:if>
       <xsl:if test="NAZWA!='Ziemia'">
       <TR>
          <TD><xsl:apply-templates select="NAZWA"/></TD>
          <TD><xsl:apply-templates select="MASA"/></TD>
          <TD><xsl:apply-templates select="PROMIE"/></TD>
          <TD><xsl:apply-templates select="DZIE"/></TD>
       </TR>
       </xsl:if>
   </xsl:template>

    <xsl:template match="NAZWA">
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="MASA">
        <xsl:value-of select="."/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@JEDNOSTKI"/>
    </xsl:template>

    <xsl:template match="PROMIE">
        <xsl:value-of select="."/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@JEDNOSTKI"/>
    </xsl:template>
    
    <xsl:template match="DZIE">
        <xsl:value-of select="."/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@JEDNOSTKI"/>
    </xsl:template>
    
    <xsl:template match="NAZWA" mode="fancy">
        <B><xsl:value-of select="."/></B>
    </xsl:template>

    <xsl:template match="MASA" mode="fancy">
        <B>
            <xsl:value-of select="."/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@JEDNOSTKI"/>
        </B> 
    </xsl:template>

    <xsl:template match="PROMIE" mode="fancy">
        <B>
            <xsl:value-of select="."/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@JEDNOSTKI"/>
        </B> 
    </xsl:template>
    
    <xsl:template match="DZIE" mode="fancy">
        <B>
            <xsl:value-of select="."/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="@JEDNOSTKI"/>
        </B> 
    </xsl:template>
    
</xsl:stylesheet>
