<xsl:stylesheet
xmlns:sql="http://icl.com/saxon/extensions/com.icl.saxon.sql.SQLElementFactory"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">

   <xsl:param name="database" select="'jdbc:odbc:planets'"/>  
   <xsl:param name="user"/>
   <xsl:param name="password"/>

   <xsl:template match="PLANETY">
      <sql:connect database="{$database}" user="{$user}" password="{$password}"    
      driver="sun.jdbc.odbc.JdbcOdbcDriver"
             xsl:extension-element-prefixes="sql"/>
      <xsl:apply-templates select="PLANETA"/>
      <xsl:call-template name="writer"/>
   </xsl:template>

   <xsl:template match="PLANETA" name="writer">
      <xsl:choose>
         <xsl:when test="NAZWA">
            <sql:insert table="planets" xsl:extension-element-prefixes="sql">
               <sql:column name="Name" select="NAZWA"/>
               <sql:column name="Mass" select="MASA"/>
               <sql:column name="Radius" select="PROMIEŃ"/>
               <sql:column name="Day" select="DZIEŃ"/>
            </sql:insert>
         </xsl:when>
         <xsl:otherwise>
            <sql:insert table="planets" xsl:extension-element-prefixes="sql">
               <sql:column name="Name" select="' '"/>
               <sql:column name="Mass" select="' '"/>
               <sql:column name="Radius" select="' '"/>
               <sql:column name="Day" select="' '"/>
            </sql:insert>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

</xsl:stylesheet>
