﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>

<xsl:template match="/">
 <html><head><title>Cuda starożytnego świata</title></head>
  <body>
   <h1 align="center">Siedem cudów starożytnego świata</h1>

   <p align="center"><img src="herodotus.jpg" width="120" height="171" /></p>
   <p>Słynny grecki historyk Herodot pisał o siedmiu wielkich osiągnięciach architektonicznych. Choć jego zapiski nie przetrwały, przyczynił się do stworzenia listy opisującej
   <strong>Siedem cudów starożytnego świata</strong>.
   </p>
   
   <p>Te cuda starożytności to 
    <xsl:for-each select="cuda_starozytnosci/cud/nazwa[@jezyk='polski']">
     <xsl:value-of select="."/>
     <xsl:choose>
      <xsl:when test="position()=last()">.</xsl:when>
      <xsl:when test="position()=last()-1"> oraz </xsl:when>
      <xsl:otherwise>, </xsl:otherwise>
     </xsl:choose>
    </xsl:for-each>
     
<!-- ** XML2e ** -->
<!-- aby śledzić przykład z książki, przeanalizuj poniższy fragment -->
    Spośród tych cudów
    <xsl:value-of select="count(cuda_starozytnosci/cud/historia/sposob_zniszczenia[. = 'trzęsienie ziemi'])" /> zniszczono przez trzęsienie ziemi, 
    <xsl:value-of select="count(//sposob_zniszczenia[. = 'pożar'])" /> zniszczono przez pożar, a
    <xsl:value-of select="count(//cud) - count(//sposob_zniszczenia)" /> stoi do dzisiaj.

</p>

   <h2>Przegląd</h2>
   <table border="1"><tr><th>Nazwa cudu</th><th>Lokalizacja</th><th>Lata<br />przetrwane</th><th>Wysokość</th></tr>
    <xsl:apply-templates select="cuda_starozytnosci/cud">
     <xsl:sort select="wysokosc" order="descending" data-type="number" />
    </xsl:apply-templates>
   </table>

   <h2>Historia</h2>
   <xsl:apply-templates select="cuda_starozytnosci/cud/historia">
    <xsl:sort select="rok_wybudowania" order="descending" data-type="number" />
   </xsl:apply-templates>

  </body>
 </html>
</xsl:template>

<xsl:template match="cud">
 <tr>
  <td valign="top">
   <a><xsl:attribute name="href">#<xsl:value-of select="nazwa[@jezyk='polski']"/></xsl:attribute>
   <strong><xsl:value-of select="nazwa[@jezyk='polski']"/></strong></a><br/>
   <xsl:apply-templates select="nazwa[@jezyk!='polski']"/>
  </td>
  <td valign="top"><xsl:value-of select="lokalizacja"/></td>
  <td valign="top">
   <xsl:choose>
    <xsl:when test="historia/rok_zniszczenia != 0">
     <xsl:choose>
      <xsl:when test="historia/rok_zniszczenia/@era = 'p.n.e.'">
       <xsl:value-of select="historia/rok_wybudowania - historia/rok_zniszczenia"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="historia/rok_wybudowania + historia/rok_zniszczenia - 1"/>
      </xsl:otherwise>
     </xsl:choose>
   </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="historia/rok_wybudowania + 2008 - 1"/>
    </xsl:otherwise>
   </xsl:choose>
  </td>
  <td valign="top">
   <xsl:choose>
    <xsl:when test="wysokosc != 0">
     <xsl:value-of select="wysokosc"/>
    </xsl:when>
    <xsl:otherwise>
      nieznana
    </xsl:otherwise>
   </xsl:choose>
  </td>
 </tr>
</xsl:template>
   
<xsl:template match="historia">
 <a><xsl:attribute name="name"><xsl:value-of select="../nazwa[@jezyk='polski']"/></xsl:attribute></a>
  <xsl:value-of select="../nazwa[@jezyk='polski']"/>
 <xsl:apply-templates select="../nazwa[@jezyk!='polski']"/>
 - obiekt zbudowany w roku <xsl:value-of select="rok_wybudowania"/><xsl:text> </xsl:text><xsl:value-of select="rok_wybudowania/@era"/>
   <xsl:choose>
    <xsl:when test="rok_zniszczenia != 0">
     i zniszczony przez <xsl:value-of select="sposob_zniszczenia"/> w roku <xsl:value-of select="rok_zniszczenia"/> <xsl:text> </xsl:text><xsl:value-of select="rok_zniszczenia/@era"/>
    </xsl:when>
    <xsl:otherwise>
     i stoi do dzisiaj.
    </xsl:otherwise>
   </xsl:choose>
 <br /><br />
</xsl:template>

<xsl:template match="nazwa[@jezyk!='polski']">
 (<em><xsl:value-of select="."/></em>)
</xsl:template>

</xsl:stylesheet>
