<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />

  <xsl:template match="/">
    <xsl:apply-templates select="/cars/manufacturers" />
  </xsl:template>

  <xsl:template match="manufacturers">
    <xsl:for-each select="manufacturer">
      <xsl:value-of select="@name" />
      <xsl:value-of select="concat(' (',@country,')&#xA;')" />
      <xsl:for-each
           select="/cars/models/model[@manufacturer = current()/@id]">
        <xsl:value-of select="concat('-',@name,' (',@year,')&#xA;')" />
      </xsl:for-each>
      <xsl:text>&#xA;</xsl:text>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>