<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      xmlns:msxsl="urn:schemas-microsoft-com:xslt"
      xmlns:user="http://www.aspnl.com/xmlns/extensions"
      xmlns:math="java.lang.Math"
  	  extension-element-prefixes="math msxsl user"
      exclude-result-prefixes="math msxsl user">

  <msxsl:script language="javascript" implements-prefix="user">
     function squareroot(num) {
       return Math.sqrt(num);
     }
  </msxsl:script>

  <xsl:output method="text" encoding="utf-8" />

  <xsl:template match="number">
    <xsl:text>Pierwiastek kwadratowy </xsl:text>
    <xsl:value-of select="." />
    <xsl:text> to </xsl:text>
    <xsl:choose>
      <xsl:when test="function-available('math:sqrt')">
        <xsl:value-of select="math:sqrt(.)" />
      </xsl:when>
      <xsl:when test="function-available('user:squareroot')">
        <xsl:value-of select="user:squareroot(number(.))" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>BRAK FUNKCJI</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
