<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      xmlns:msxsl="urn:schemas-microsoft-com:xslt"
      xmlns:user="http://www.aspnl.com/xmlns/extensions">

  <msxsl:script language="javascript" implements-prefix="user">
     function maxlen(nodelist) {
       var len = 0;
       for (var i=1; i &lt; nodelist.length; i++) {
         var s = new String(nodelist.nextNode().text);
         if(len &lt; s.length) {
           len = s.length;
         }
       }
       return len;
     }
     
     function inschars(num,ch) {
       var s = '';
       for (var i=0; i &lt; num; i++) {
         s = s + ch;
       }
       return s;
     }
  </msxsl:script>

  <xsl:output method="text" encoding="utf-8" />

  <xsl:template match="/">
    <xsl:variable name="maxlen" select="user:maxlen(/teams/team)" />
    <xsl:for-each select="/teams/team">
      <xsl:value-of select="." />
      <xsl:value-of select="user:inschars($maxlen - string-length(.),'-')" />
      <xsl:text> </xsl:text>
      <xsl:value-of select="$maxlen - string-length(.)" />
      <xsl:text>&#xA;</xsl:text>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>