<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />

  <xsl:template match="/">
    <xsl:variable name="points">
      <xsl:call-template name="calcpoints">
        <xsl:with-param name="matches"
                        select="/competition/matches/match" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:apply-templates select="$points/points">
      <xsl:sort select="." order="descending" />
      <xsl:sort select="@for - @against" order="descending" />
      <xsl:sort select="@for" order="descending" />
      <xsl:with-param name="teams" select="//team" />
    </xsl:apply-templates>
  </xsl:template>
  
  <xsl:template match="points">
    <xsl:param name="teams" />
    <xsl:value-of select="$teams[@id = current()/@team]" />
    <xsl:text> </xsl:text><xsl:value-of select="." />
    <xsl:text> </xsl:text><xsl:value-of select="@for" />
    <xsl:text> </xsl:text><xsl:value-of select="@against" />
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>

  <xsl:template name="calcpoints">
    <xsl:param name="matches" />
    <xsl:variable name="result">
      <xsl:if test="count($matches) &gt; 1">
        <xsl:call-template name="calcpoints">
          <xsl:with-param name="matches"
                          select="$matches[position() != 1]" />
        </xsl:call-template>
      </xsl:if>
    </xsl:variable>
    <xsl:for-each select="/competition/teams/team">
      <xsl:variable name="id" select="@id" />
      <xsl:variable name="points">
        <xsl:choose>
          <xsl:when test="$result/points[@team = $id]">
            <for><xsl:value-of
                      select="$result/points[@team = $id]/@for" /></for>
            <against>
              <xsl:value-of
                   select="$result/points[@team = $id]/@against" />
            </against>
            <xsl:value-of select="$result/points[@team = $id]" />
          </xsl:when>
          <xsl:otherwise>
            <for>0</for><against>0</against>0
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$matches[1]/@hometeam = $id">
          <points team="{$id}"
                  for="{$matches[1]/@homescore + $points/for}"
                  against="{$matches[1]/@awayscore + $points/against}">
            <xsl:choose>
              <xsl:when test="$matches[1]/@homescore &gt;
                              $matches[1]/@awayscore">
                <xsl:value-of select="2 + $points/text()" />
              </xsl:when>
              <xsl:when test="$matches[1]/@homescore &lt;
                              $matches[1]/@awayscore">
                <xsl:value-of select="$points/text()" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="1 + $points/text()" />
              </xsl:otherwise>
            </xsl:choose>
          </points>
        </xsl:when>
        <xsl:when test="$matches[1]/@awayteam = $id">
          <points team="{$id}"
                  for="{$matches[1]/@awayscore + $points/for}"
                  against="{$matches[1]/@homescore + $points/against}">
            <xsl:choose>
              <xsl:when test="$matches[1]/@homescore &gt;
                              $matches[1]/@awayscore">
                <xsl:value-of select="$points/text()" />
              </xsl:when>
              <xsl:when test="$matches[1]/@homescore &lt;
                              $matches[1]/@awayscore">
                <xsl:value-of select="2 + $points/text()" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="1 + $points/text()" />
              </xsl:otherwise>
            </xsl:choose>
          </points>
        </xsl:when>
        <xsl:otherwise>
          <xsl:copy-of select="$result/points[@team = $id]" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>