<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:car="http://www.example.com/xmlns/car"
  xmlns:man="http://www.example.com/xmlns/manufacturer"
  exclude-result-prefixes="car man">

  <xsl:output method="html" version="4.0" />
  
  <xsl:template match="/">
    <html>
    <body>
      <h1>Samochody</h1>
      <xsl:apply-templates select="/car:cars/man:manufacturers" />
    </body>
    </html>
  </xsl:template>
  
  <xsl:template match="man:manufacturers">
    <xsl:for-each select="man:manufacturer">
      <h2><xsl:value-of select="@man:name" /></h2>
      <p><i>Kraj: <xsl:value-of select="@man:country" /></i></p>
      <xsl:for-each select="/car:cars/car:models/car:model[@man:id = current()/@man:id]">
        <ul>
          <li>
            <xsl:value-of select="@car:name" />
            <xsl:text> (</xsl:text>
            <xsl:value-of select="@car:year" />
            <xsl:text>)</xsl:text>
          </li>
        </ul>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
