<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:car="TYXSLT21DAYS">

  <xsl:output method="html" version="4.0" encoding="UTF-8" />
  <xsl:strip-space elements="*" />

  <car:models>
    <car:model name="Golf" manufacturer="VW" year="1999" />
    <car:model name="Camry" manufacturer="TY" year="1999" />
    <car:model name="Focus" manufacturer="FO" year="2000" />
    <car:model name="Civic" manufacturer="HO" year="2000" />
    <car:model name="Prizm" manufacturer="CV" year="2000" />
    <car:model name="Celica" manufacturer="TY" year="2000" />
    <car:model name="Mustang" manufacturer="FO" year="2001" />
    <car:model name="Passat" manufacturer="VW" year="2001" />
    <car:model name="Accord" manufacturer="HO" year="2002" />
    <car:model name="Corvette" manufacturer="CV" year="2002" />
  </car:models>

  <xsl:template match="/">
    <html>
    <body>
      <h1>Samochody</h1>
      <xsl:apply-templates />
    </body>
    </html>
  </xsl:template>

  <xsl:template match="manufacturers">
    <xsl:for-each select="manufacturer">
      <h2><xsl:value-of select="@name" /></h2>
      <p><i>Kraj: <xsl:value-of select="@country" /></i></p>
      <xsl:for-each select="document('')/xsl:stylesheet/car:models/car:model[@manufacturer = current()/@id]">
        <ul>
          <li>
            <xsl:value-of select="@name" />
            <xsl:text> (</xsl:text>
            <xsl:value-of select="@year" />
            <xsl:text>)</xsl:text>
          </li>
        </ul>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
