<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html" version="4.0" encoding="UTF-8" />
  <xsl:strip-space elements="*" />

  <xsl:variable name="cars" select="document('14list01.xml')" />

  <xsl:template match="/">
    <html>
    <body>
      <h1>Samochody</h1>
      <xsl:apply-templates />
    </body>
    </html>
  </xsl:template>

  <xsl:template match="manufacturers">
    <xsl:for-each select="manufacturer">
      <h2><xsl:value-of select="@name" /></h2>
      <p><i>Kraj: <xsl:value-of select="@country" /></i></p>
      <xsl:for-each
           select="$cars/cars/model[@manufacturer = current()/@id]">
        <ul>
          <li>
            <xsl:value-of select="@name" />
            <xsl:text> (</xsl:text>
            <xsl:value-of select="@year" />
            <xsl:text>)</xsl:text>
          </li>
        </ul>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
