<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />

  <xsl:variable name="monthnames">
    <month number="1">Styczeń</month>
    <month number="2">Luty</month>
    <month number="3">Marzec</month>
    <month number="4">Kwiecień</month>
    <month number="5">Maj</month>
    <month number="6">Czerwiec</month>
    <month number="7">Lipiec</month>
    <month number="8">Sierpień</month>
    <month number="9">Wrzesień</month>
    <month number="10">Październik</month>
    <month number="11">Listopad</month>
    <month number="12">Grudzień</month>
  </xsl:variable>

  <xsl:template match="/">
    <xsl:call-template name="formatdate" />
  </xsl:template>

  <xsl:template name="formatdate">
    <xsl:param name="datetime" select="." />
    <xsl:variable name="year" select="number(substring-before($datetime,'-'))" />
    <xsl:variable name="month" select="number(substring($datetime,6,2))" />
    <xsl:variable name="day" select="number(substring($datetime,9,2))" />
    <xsl:text>Dzisiaj jest </xsl:text>
    <xsl:value-of select="$day" /><xsl:text> </xsl:text>
    <xsl:value-of select="$monthnames/month[@number=$month]" />
    <xsl:value-of select="$year" />
    <xsl:text>r.</xsl:text>
  </xsl:template>
</xsl:stylesheet>
