<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />

  <xsl:param name="week">1</xsl:param>

  <xsl:template match="/">
    <xsl:variable name="weekmenu">
      <xsl:call-template name="getmenu" />
    </xsl:variable>
    <xsl:value-of select="$weekmenu/dish[1]" />
    <xsl:text>, </xsl:text>
    <xsl:value-of select="$weekmenu/dish[2]" />
    <xsl:text> oraz </xsl:text>
    <xsl:value-of select="$weekmenu/dish[3]" />
    <xsl:text> za jedyne $27.95</xsl:text>
  </xsl:template>

  <xsl:template name="getmenu">
    <xsl:copy-of select="/menu/appetizers/dish[position() =
       ((($week - 1) mod count(/menu/appetizers/dish)) + 1)]" />
    <xsl:copy-of select="/menu/entrees/dish[position() =
       ((($week - 1) mod count(/menu/entrees/dish)) + 1)]" />
    <xsl:copy-of select="/menu/desserts/dish[position() =
       ((($week - 1) mod count(/menu/desserts/dish)) + 1)]" />
  </xsl:template>
</xsl:stylesheet>
