<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />
  <xsl:strip-space elements="*" />

  <xsl:decimal-format name="inf" infinity="&#8734;" NaN="Niepoprawna" />
  <xsl:decimal-format name="EURO"
                      decimal-separator=","
                      grouping-separator="."
                      digit="@" />

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="numbers">
    <xsl:apply-templates />
    <xsl:text>&#xA;===special values===&#xA;</xsl:text>
    <xsl:value-of select="format-number(1 div 0,'#,##0.00','inf')" />
    <xsl:text>&#xA;</xsl:text>
    <xsl:value-of select="format-number(-1 div 0,'#,##0.00','inf')" />
    <xsl:text>&#xA;</xsl:text>
    <xsl:value-of select="format-number('xyz','#,##0.00','inf')" />
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>

  <xsl:template match="number">
    <xsl:text>&#xA;===</xsl:text>
    <xsl:value-of select="." />
    <xsl:text>===&#xA;</xsl:text>

    <xsl:value-of select="format-number(.,'#,##0.00')" />
    <xsl:text>&#xA;</xsl:text>
    <xsl:value-of select="format-number(.,'###0.0##')" />
    <xsl:text>&#xA;</xsl:text>
    <xsl:value-of select="format-number(.,'#,###.00')" />
    <xsl:text>&#xA;</xsl:text>
    <xsl:value-of select="format-number(.,'#0')" />
    <xsl:text>&#xA;</xsl:text>
    <xsl:value-of select="format-number(.,'@.@@0,00','EURO')" />
    <xsl:text>&#xA;</xsl:text>
    <xsl:value-of select="format-number(.,'# @.@@0,00;# -@.@@0,00','EURO')" />
    <xsl:text>&#xA;===&#xA;</xsl:text>
  </xsl:template>
</xsl:stylesheet>
