<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />

  <xsl:variable name="monthnames">
    <month number="1">styczeń</month>
    <month number="2">luty</month>
    <month number="3">marzec</month>
    <month number="4">kwiecień</month>
    <month number="5">maj</month>
    <month number="6">czerwiec</month>
    <month number="7">lipiec</month>
    <month number="8">sierpień</month>
    <month number="9">wrzesień</month>
    <month number="10">październik</month>
    <month number="11">listopad</month>
    <month number="12">grudzień</month>
  </xsl:variable>

  <xsl:template match="/">
    <xsl:call-template name="formatdate" />
    <xsl:text>&#xA;</xsl:text>
    <xsl:call-template name="formattime" />
  </xsl:template>

  <xsl:template name="formatdate">
    <xsl:param name="datetime" select="." />
    <xsl:variable name="year" select="substring-before($datetime,'-')" />
    <xsl:variable name="month" select="number(substring($datetime,6,2))" />
    <xsl:variable name="day" select="substring($datetime,9,2)" />
    <xsl:text>Dzisiaj jest </xsl:text>
    <xsl:value-of select="$day" /><xsl:text> </xsl:text>
    <xsl:value-of select="$monthnames/month[@number=$month]" />
    <xsl:text> </xsl:text><xsl:value-of select="$year" />
    <xsl:text>r.</xsl:text>
  </xsl:template>

  <xsl:template name="formattime">
    <xsl:param name="datetime" select="." />
    <xsl:variable name="time" select="substring-after($datetime,'T')" />
    <xsl:variable name="hours" select="substring($time,1,5)" />
    <xsl:variable name="seconds" select="substring($time,7,2)" />
    <xsl:variable name="zone" select="substring($time,9,5)" />
    <xsl:text>Aktualny czas: </xsl:text>
    <xsl:value-of select="$hours" />
    <xsl:text> godzin i </xsl:text><xsl:value-of select="$seconds" />
    <xsl:text> sekund w strefie </xsl:text>
    <xsl:value-of select="$zone" />
    <xsl:text>.</xsl:text>
  </xsl:template>
</xsl:stylesheet>
