<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" version="1.0" encoding="UTF-8" />

  <xsl:param name="id" />
  <xsl:param name="dish" />
  <xsl:param name="price" />
  <xsl:param name="type" />

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="menu">
    <xsl:copy>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <xsl:template match="appetizers|entrees|desserts">
    <xsl:copy>
      <xsl:apply-templates />
      <xsl:if test="name() = $type">
        <xsl:call-template name="insertdish" />
      </xsl:if>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="dish">
    <xsl:copy-of select="." />
  </xsl:template>

  <xsl:template name="insertdish">
    <dish id="{$id}" price="{$price}">
      <xsl:value-of select="$dish" />
    </dish>
  </xsl:template>
</xsl:stylesheet>