<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html" version="4.0" />

  <xsl:variable name="bgcolor">
    <body>#cccccc</body>
    <table>#ffffff</table>
    <row1999>#cccccc</row1999>
    <row2000>#ffffff</row2000>
    <row2001>#ffcccc</row2001>
  </xsl:variable>

  <xsl:template match="/">
    <html>
    <body bgcolor="{$bgcolor/body}">
      <xsl:apply-templates select="cars/models" />
    </body>
    </html>
  </xsl:template>

  <xsl:template match="models">
    <table bgcolor="{$bgcolor/table}" width="75%">
      <xsl:for-each select="model">
        <tr>
          <xsl:attribute name="bgcolor">
            <xsl:choose>
              <xsl:when test="@year = '1999'">
                <xsl:value-of select="$bgcolor/row1999" />
              </xsl:when>
              <xsl:when test="@year = '2000'">
                <xsl:value-of select="$bgcolor/row2000" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$bgcolor/row2001" />
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:call-template name="car" />
        </tr>
      </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template name="car">
    <xsl:variable name="mfc" select="@manufacturer" />
    <td><xsl:value-of select="@name" /></td>
    <td><xsl:value-of
             select="/cars/manufacturers/manufacturer[@id = $mfc]/@name" />
     </td>
    <td><xsl:value-of select="@year" /></td>
  </xsl:template>
</xsl:stylesheet>