<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html" version="4.0" encoding="UTF-8" />

  <xsl:attribute-set name="table">
    <xsl:attribute name="bgcolor">#9999ff</xsl:attribute>
    <xsl:attribute name="width">75%</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="tableheader">
    <xsl:attribute name="bgcolor">#ffffcc</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="tablerow">
    <xsl:attribute name="bgcolor">#ccccff</xsl:attribute>
  </xsl:attribute-set>

  <xsl:template match="/">
    <html>
    <body>
      <xsl:apply-templates />
    </body>
    </html>
  </xsl:template>

  <xsl:template match="wines">
    <table xsl:use-attribute-sets="table">
      <xsl:call-template name="wineheader" />
      <xsl:apply-templates />
    </table>
  </xsl:template>

  <xsl:template name="wineheader">
    <tr xsl:use-attribute-sets="tableheader">
      <td>Nazwa</td>
      <td>Pochodenie</td>
      <td>Rok</td>
      <td>Kolor</td>
      <td>Rodzaj</td>
    </tr>
  </xsl:template>

  <xsl:template match="wine">
    <tr xsl:use-attribute-sets="tablerow">
      <td><xsl:value-of select="." /></td>
      <td><xsl:value-of select="@origin" /></td>
      <td><xsl:value-of select="@year" /></td>
      <td><xsl:value-of select="@color" /></td>
      <td><xsl:value-of select="@type" /></td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
