<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:saxon="http://icl.com/saxon"
  extension-element-prefixes="saxon"
  exclude-result-prefixes="saxon">

  <xsl:output method="text" encoding="UTF-8" />
  <xsl:strip-space elements="*" />

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="element-available('saxon:assign')">
        <xsl:variable name="total" select="0" saxon:assignable="yes" />
        <xsl:for-each select="/numbers/number">
          <saxon:assign name="total" select="$total - number(.)" />
        </xsl:for-each>
        <xsl:value-of select="$total" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>Element saxon:assign jest niedostępny</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
