<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:saxon="http://icl.com/saxon"
  extension-element-prefixes="saxon"
  exclude-result-prefixes="saxon">

  <xsl:variable name="dir">c:\xml</xsl:variable>

  <xsl:output method="html" encoding="UTF-8" />
  <xsl:strip-space elements="*" />

  <xsl:template match="/">
    <html>
    <body>
    <h1>Wiadomości</h1>
    <xsl:apply-templates select="//newsitem" />
    </body>
    </html>
  </xsl:template>
  
  <xsl:template match="newsitem">
    <saxon:output href="{$dir}\news{@id}.html">
      <xsl:call-template name="createnewsfile" />
      <xsl:fallback />
    </saxon:output>
    <xsl:choose>
      <xsl:when test="element-available('saxon:output')">
        <a href="{$dir}\news{@id}.html">
          <xsl:value-of select="@title" />
        </a>
        <br />
      </xsl:when>
      <xsl:otherwise>
        <hr />
        <xsl:call-template name="createnewsitem" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="createnewsitem">
    <h2><xsl:value-of select="@title" /></h2>
    <p><i><xsl:value-of select="@date" /></i></p>
    <p>
      <xsl:value-of select="." />
    </p>
  </xsl:template>
  
  <xsl:template name="createnewsfile">
    <html>
    <body>
    <xsl:call-template name="createnewsitem" />
    </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
