<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:saxon="http://icl.com/saxon"
  extension-element-prefixes="saxon"
  exclude-result-prefixes="saxon">

  <xsl:output method="text" encoding="UTF-8" />
  <xsl:strip-space elements="*" />
  <xsl:variable name="dishes" select="document('19list01.xml')//dish" />

  <xsl:template match="/">
    <xsl:call-template name="displayorder">
      <xsl:with-param name="order">
        <xsl:apply-templates select="//order" />
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="order">
    <item price="{$dishes[@id = current()/@id]/@price}">
      <xsl:copy-of select="@*" />
      <xsl:value-of select="$dishes[@id = current()/@id]" />
    </item>
  </xsl:template>
  
  <xsl:template name="displayorder">
    <xsl:param name="order" />
    <xsl:for-each select="$order/item">
      <xsl:value-of select="@quantity" />
      <xsl:text> x </xsl:text>
      <xsl:value-of select="." />
      <xsl:text> ($</xsl:text>
      <xsl:value-of select="@price" />
      <xsl:text>) = $</xsl:text>
      <xsl:value-of select="format-number(@price * @quantity, '0.00')" />
      <xsl:text>&#xA;</xsl:text>
    </xsl:for-each>
    <xsl:text>&#xA;Razem: $</xsl:text>
    <xsl:value-of select="saxon:sum($order/item,saxon:expression('@price * @quantity'))" />
  </xsl:template>
</xsl:stylesheet>
