<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:saxon="http://icl.com/saxon"
  extension-element-prefixes="saxon"
  exclude-result-prefixes="saxon">

  <xsl:output method="text" encoding="UTF-8" />
  <xsl:strip-space elements="*" />
  <xsl:variable name="dishes" select="document('19list01.xml')//dish" />
  <xsl:variable name="total" select="0" saxon:assignable="yes" />

  <xsl:template match="/">
    <xsl:apply-templates select="//order" />
    <xsl:text>&#xA;Razem: $</xsl:text>
    <xsl:value-of select="$total" />
  </xsl:template>

  <xsl:template match="order">
    <xsl:variable name="price"
                  select="$dishes[@id = current()/@id]/@price" />
    <xsl:value-of select="@quantity" />
    <xsl:text> x </xsl:text>
    <xsl:value-of select="$dishes[@id = current()/@id]" />
    <xsl:text> ($</xsl:text>
    <xsl:value-of select="$price" />
    <xsl:text>) = $</xsl:text>
    <xsl:value-of select="format-number($price * @quantity, '0.00')" />
    <xsl:text>&#xA;</xsl:text>
    <saxon:assign name="total" select="$total + $price * @quantity" />
  </xsl:template>
</xsl:stylesheet>
