<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="utf-8" />

  <xsl:template match="/">
    <xsl:variable name="maxlen">
      <xsl:call-template name="maxlen">
        <xsl:with-param name="strings" select="/competition/teams/team" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:for-each select="/competition/teams/team">
      <xsl:value-of select="." />
      <xsl:call-template name="insertspaces">
        <xsl:with-param name="number" select="$maxlen - string-length(.)" />
      </xsl:call-template>
      <xsl:text> </xsl:text>
      <xsl:value-of select="$maxlen - string-length(.)" />
      <xsl:text>&#xA;</xsl:text>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="maxlen">
    <xsl:param name="strings" />
    <xsl:choose>
      <xsl:when test="count($strings) &gt; 1">
        <xsl:variable name="result">
          <xsl:call-template name="maxlen">
            <xsl:with-param name="strings" select="$strings[position() != 1]" />
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="$result &gt; string-length($strings[1])">
            <xsl:value-of select="$result" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="string-length($strings[1])" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="string-length($strings[1])" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="insertspaces">
    <xsl:param name="number">0</xsl:param>
    <xsl:if test="$number &gt; 1">
      <xsl:call-template name="insertspaces">
        <xsl:with-param name="number" select="$number - 1" />
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="$number &gt; 0">
      <xsl:text> </xsl:text>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
