<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />
  <xsl:strip-space elements="*" />
  <xsl:variable name="dishes" select="document('18list03.xml')//dish" />

  <xsl:template match="/">
    <xsl:apply-templates select="//order" />
    <xsl:variable name="total">
      <xsl:apply-templates select="//order" mode="total" />
    </xsl:variable>
    <xsl:text>&#xA;Razem: $</xsl:text>
    <xsl:value-of select="sum($total/subtotal)" />
  </xsl:template>

  <xsl:template match="order">
    <xsl:value-of select="@quantity" />
    <xsl:text> x </xsl:text>
    <xsl:value-of select="$dishes[@id = current()/@id]" />
    <xsl:text> ($</xsl:text>
    <xsl:value-of select="$dishes[@id = current()/@id]/@price" />
    <xsl:text>) = $</xsl:text>
    <xsl:value-of select="format-number($dishes[@id = current()/@id]/@price * @quantity, '0.00')" />
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>
  
  <xsl:template match="order" mode="total">
    <subtotal>
      <xsl:value-of
           select="$dishes[@id = current()/@id]/@price * @quantity" />
    </subtotal>
  </xsl:template>
</xsl:stylesheet>
