<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />
  <xsl:variable name="teams" select="//team" />

  <xsl:template match="/">
    <xsl:variable name="points">
      <xsl:apply-templates select="/competition/matches" />
    </xsl:variable>
    <xsl:variable name="ranking">
      <xsl:for-each select="/competition/teams/team">
        <points id="{@id}"
                for="{sum($points/points[@id = current()/@id]/@for)}"
                against="{sum($points/points[@id = current()/@id]/@against)}">
        <xsl:value-of select="sum($points/points[@id = current()/@id])" />
        </points>
      </xsl:for-each>
    </xsl:variable>
    <xsl:apply-templates select="$ranking/points">
      <xsl:sort select="." order="descending" />
      <xsl:sort select="@for - @against" order="descending" />
      <xsl:sort select="@for" order="descending" />
      <xsl:with-param name="teams" select="//team" />
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="points">
    <xsl:value-of select="$teams[@id = current()/@id]" />
    <xsl:text> </xsl:text><xsl:value-of select="." />
    <xsl:text> </xsl:text><xsl:value-of select="@for" />
    <xsl:text> </xsl:text><xsl:value-of select="@against" />
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>
  
  <xsl:template match="matches">
    <xsl:for-each select="match">
      <xsl:choose>
        <xsl:when test="@homescore &gt; @awayscore">
          <points id="{@hometeam}" for="{@homescore}"
                  against="{@awayscore}">2</points>
          <points id="{@awayteam}" for="{@awayscore}"
                  against="{@homescore}">0</points>
        </xsl:when>
        <xsl:when test="@homescore &lt; @awayscore">
          <points id="{@hometeam}" for="{@homescore}"
                  against="{@awayscore}">0</points>
          <points id="{@awayteam}" for="{@awayscore}"
                  against="{@homescore}">2</points>
        </xsl:when>
        <xsl:otherwise>
          <points id="{@hometeam}" for="{@homescore}"
                  against="{@awayscore}">1</points>
          <points id="{@awayteam}" for="{@awayscore}"
                  against="{@homescore}">1</points>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>