<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />

  <xsl:param name="factorial">1</xsl:param>

  <xsl:template match="/">
    <xsl:call-template name="calculate">
      <xsl:with-param name="num" select="$factorial" />
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="calculate">
    <xsl:param name="num">1</xsl:param>
    <xsl:message>wartość parametru: <xsl:value-of select="$num" /></xsl:message>
    <xsl:choose>
      <xsl:when test="$num = 1">
        <xsl:value-of select="$num" />
            <xsl:message>zwracana wartość: <xsl:value-of select="$num" /></xsl:message>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="result">
          <xsl:call-template name="calculate">
            <xsl:with-param name="num" select="$num - 1" />
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$result * $num" />
            <xsl:message>zwracana wartość: <xsl:value-of select="$result * $num" /></xsl:message>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
