<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" indent="yes" encoding="UTF-8" />

  <xsl:template match="/">
    <xsl:apply-templates select="names/name" />
  </xsl:template>
  
  <xsl:template match="names">
    <xsl:copy>
      <xsl:apply-templates />
    </xsl:copy>
  </xsl:template>

  <xsl:template match="name">
    <xsl:copy>
      <xsl:call-template name="breakdown">
        <xsl:with-param name="fullname" select="normalize-space()" />
      </xsl:call-template>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="breakdown">
    <xsl:param name="fullname" />
    <xsl:choose>
      <xsl:when test="contains($fullname,' ')">
        <firstname>
          <xsl:value-of select="substring-before($fullname,' ')" />
        </firstname>
        <xsl:call-template name="breakdown">
          <xsl:with-param name="fullname"
               select="substring-after($fullname,' ')" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <lastname><xsl:value-of select="$fullname" /></lastname>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>