<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" exclude-result-prefixes="car m"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:car="http://www.example.com/xmlns/car"
  xmlns:m="http://www.example.com/xmlns/manufacturer">

  <xsl:output method="html" encoding="UTF-8" />
  <xsl:strip-space elements="*" />
  <xsl:key name="mfc" match="m:manufacturer" use="@m:id" />

  <xsl:template match="/">
    <html>
    <body>
      <xsl:apply-templates select="/car:cars/car:models" />
      <hr />
      <xsl:apply-templates select="/car:cars/m:manufacturers" />
    </body>
    </html>
  </xsl:template>

  <xsl:template match="car:models">
    <h2>Modele samochodów</h2>
    <ul>
      <xsl:for-each select="car:model">
        <li>
          <a href="#{generate-id(key('mfc', @m:id))}">
            <xsl:value-of select="key('mfc', @m:id)/@m:name" />
          </a>
          <xsl:text> </xsl:text>
          <xsl:value-of select="@car:name" />
          <xsl:value-of select="concat(' (',@car:year,')')" />
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>
  
  <xsl:template match="m:manufacturers">
    <h2>Producenci</h2>
    <ul>
      <xsl:apply-templates />
    </ul>
  </xsl:template>

  <xsl:template match="m:manufacturer">
    <li>
      <a name="{generate-id()}">
        <xsl:value-of select="@m:name" />
      </a>
        <xsl:value-of select="concat(' (',@m:country,')')" />
    </li>
  </xsl:template>
</xsl:stylesheet>
